from marshmallow import Schema, fields, post_load, EXCLUDE

from travel.avia.price_index.models.search_form import SearchForm
from travel.avia.price_index.schemas.filters import FiltersSchema
from travel.avia.price_index.schemas.query import QuerySchema
from travel.avia.price_index.schemas.range import RangeSchema


class SearchFormSchema(Schema):
    class Meta:
        unknown = EXCLUDE

    date_range = fields.Nested(RangeSchema, data_key='range')
    query = fields.Nested(QuerySchema)
    filters = fields.Nested(FiltersSchema, missing=lambda: FiltersSchema().load({}))
    format_version = fields.String(missing='1.0.0', data_key='formatVersion')
    query_source = fields.Integer(required=False, data_key='querySource')

    @post_load
    def make_search_form(self, data, *args, **kwargs):
        return SearchForm(**data)
