import os
from datetime import date, timedelta
from urllib.parse import urlparse, parse_qs

d = os.popen(
    "executer \"p_exec %avia_front grep 'GET /dynamic/' /var/log/nginx/access.log | head -n 200 | cut -d ' ' -f 6\""
)

bullets = []
for row in d.readlines():
    tokens = row.strip().split(' ')

    if len(tokens) < 2:
        continue
    raw_url = tokens[1]

    if raw_url.startswith('/dynamic/'):
        try:
            url = urlparse(raw_url)
            query = parse_qs(url.query)

            if 'month_number' in query:
                start_month_number = query['month_number'][0]
                end_month_number = query['month_number'][0]
            else:
                start_month_number = query['start_month_number'][0]
                end_month_number = query['end_month_number'][0]

            when = None
            if 'delta' in query or 'when' not in query:
                delta = int(query.get('delta', [0])[0])
                when = date(int(start_month_number[0:4]), int(end_month_number[4:6]), 1)

                if delta:
                    return_date = when + timedelta(days=delta)
                else:
                    return_date = None
            else:
                when = query['when'][0]
                return_date = query['return_date'][0] if 'return_date' in query else None

                when = date(int(when[0:4]), int(when[5:7]), int(when[8:10]))

                if return_date:
                    return_date = date(int(return_date[0:4]), int(return_date[5:7]), int(return_date[8:10]))

            query = {
                'from_id': query['fromId'][0],
                'to_id': query['toId'][0],
                'forward_date': when,
                'backward_date': return_date,
                'is_business': query['klass'][0] != 'economy',
                'adult_seats': int(query['adult_seats'][0]),
                'children_seats': int(query['children_seats'][0]),
                'infant_seats': int(query['adult_seats'][0]),
                'national_version': 1,
            }

            end_year = int(end_month_number[0:4])
            end_month = int(end_month_number[4:6])
            if end_month == 12:
                end_year += 1
                end_month = 1
            else:
                end_month += 1
            date_range = {
                'start': date(int(start_month_number[0:4]), int(start_month_number[4:6]), 1),
                'end': date(end_year, end_month, 1) - timedelta(days=1),
            }

            bullets.append({'query': query, 'date_range': date_range})
        except Exception as e:
            pass

print(bullets)
