import random
from itertools import islice
from datetime import date, timedelta
import ujson

file_path = '/Users/mbobrov/Desktop/directions'
output_file_path = '/Users/mbobrov/Desktop/bullets'
directions_number = 1000
lines = []
bullets = []
target_path = '/search_methods/v1/min_price_batch_search/ru'
number_of_bullets = 50000


def write_bullet_to_output(output, line):
    tokens = line.strip().split('\t')
    days_from_today = random.randint(0, 30)
    min_requests = [
        {
            'from_id': tokens[1],
            'to_id': tokens[2],
            'forward_date': (date.today() + timedelta(days=delta)).strftime('%Y-%m-%d'),
        }
        for delta in range(days_from_today, days_from_today + 60)
    ]

    request = {'min_requests': min_requests}
    str_request = ujson.dumps(request)
    bullet = '{} {}\n{}\n'.format(len(str_request), target_path, str_request)
    output.write(bullet)


def generate_bullets():
    output = open(output_file_path, 'w')
    output.write('[Content-Type: application/json]\n')
    with open(file_path, 'r') as f:
        top_directions = list(islice(f, 1, directions_number + 1))

    for _ in range(0, number_of_bullets):
        direction_idx = random.randint(0, directions_number - 1)
        write_bullet_to_output(output, top_directions[direction_idx])

    output.close()


if __name__ == '__main__':
    generate_bullets()
