import csv
from datetime import date, timedelta

# \copy (
# select from_id, to_id, forward_date, backward_date
# from plane_variant
# group by from_id, to_id, forward_date, backward_date
#  To '/tmp/test.csv' With CSV


def parse_date(d):
    tt = d.split('-')
    return date(int(tt[0]), int(tt[1]), int(tt[2]))


with open('/tmp/raw_bullets.csv') as f:
    spamreader = csv.reader(f, delimiter=',')

    for row in spamreader:
        from_id = int(row[0])
        to_id = int(row[1])
        forward = parse_date(row[2])
        backward = parse_date(row[3])

        start = date(forward.year, forward.month, 1)
        finish = start + timedelta(days=30)

        for a, c, i in ([1, 0, 0], [2, 0, 0], [2, 1, 0], [2, 0, 1]):
            print(
                (
                    "2 {host}/v3/search/ru/{start}/{finish}/{forward}/{backward}/"
                    "{from_id}/{to_id}/{adults}/{children}/{infants}".format(
                        host='http://price-index-load.common.yandex.net',
                        start=start.isoformat(),
                        finish=finish.isoformat(),
                        forward=row[2],
                        backward=row[3],
                        from_id=from_id,
                        to_id=to_id,
                        adults=a,
                        children=c,
                        infants=i,
                    )
                )
            )
            print("{}")
