from psycopg2.extensions import adapt as sqlescape
from sqlalchemy.sql import compiler


def compile_query(query):
    dialect = query.session.bind.dialect
    statement = query.statement
    comp = compiler.SQLCompiler(dialect, statement)
    comp.compile()
    enc = dialect.encoding
    params = {}
    for k, v in comp.params.items():
        if isinstance(v, str):
            v = v.encode(enc)
        params[k] = sqlescape(v)
    print('-------------------------')
    print((comp.string.encode(enc) % params).decode(enc))
    print('-------------------------')
