from logging import getLogger
from decorator import decorator

from flask import Response
import ujson

from travel.avia.price_index.lib.db.extentions import session_scope
from travel.avia.price_index.lib.db.storage import slave_storage, storage

error_logger = getLogger('error')


class BadRequest(Exception):
    def __init__(self, message, data=None):
        self.message = message
        self.data = data or message


def json_response(data, status):
    return Response(response=ujson.dumps(data), status=status, mimetype='application/json')


def failed_json_response():
    return json_response({'status': 'fail'}, status=500)


def ok_json_response():
    return json_response({'status': 'done'}, status=200)


def bad_request_response(data=None):
    return json_response(
        {
            'status': 'fail',
            'data': data,
        },
        400,
    )


@decorator
def jsend_view(fn, *args, **kwargs):
    try:
        try:
            return json_response({'status': 'ok', 'data': fn(*args, **kwargs)}, 200)
        except BadRequest as b:
            return bad_request_response(b.data)

    except Exception as e:
        error_logger.exception('Method error: %s', e)
        return json_response(
            {
                'status': 'fail',
                'data': str(e),
            },
            500,
        )


def slave_wrapper(fn):
    def wrapper(*args, **kwargs):
        with session_scope(slave_storage) as session:
            return fn(session, *args, **kwargs)

    return wrapper


def master_wrapper(fn):
    def wrapper(*args, **kwargs):
        with session_scope(storage) as session:
            return fn(session, *args, **kwargs)

    return wrapper
