from logging import Logger, getLogger

import ujson
from marshmallow import ValidationError

from travel.avia.price_index.lib import result_operation
from travel.avia.price_index.lib.result_builder import result_builder
from travel.avia.price_index.lib.indexer import indexer, Indexer

from travel.avia.price_index.lib.db.storage import Storage, storage
from travel.avia.price_index.schemas.query import IndexQuerySchema
from travel.avia.price_index.views.helpers import BadRequest


class IndexView2(object):
    def __init__(self, indexer, storage, logger):
        # type: (Indexer, Storage, Logger) -> None
        self._indexer = indexer
        self._storage = storage
        self._logger = logger

    def parse_form(self, params, body):
        raw_data = ujson.loads(body)
        params['raw_data'] = raw_data
        try:
            result = IndexQuerySchema().load(params)
        except ValidationError as e:
            raise BadRequest('Can not parse search form') from e

        return result

    def process(self, session, index_query):
        result_model = result_builder.build(index_query)
        if not result_model.is_empty():
            result_operation.on_conflict.save(session, result_model)
        else:
            result_operation.delete.save(session, result_model)


index_view2 = IndexView2(indexer=indexer, storage=storage, logger=getLogger(__name__))
