PY3_LIBRARY()

OWNER(g:avia)

PEERDIR(
    contrib/python/Flask
    contrib/python/alembic
    contrib/python/decorator
    contrib/python/gunicorn
    contrib/python/marshmallow
    contrib/python/more-itertools
    contrib/python/psycopg2
    contrib/python/python-json-logger
    contrib/python/raven
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/ujson

    travel/library/python/avia_mdb_replica_info
    travel/library/python/cloud_logger
    travel/library/python/logbroker
    travel/library/python/tracing/flask_opentracing_helpers
    travel/library/python/tvm_ticket_provider

    travel/avia/library/proto/search_result/v1
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/shared_objects
)

PY_SRCS(
    app.py
    db_models/base_model.py
    db_models/direction_price.py
    db_models/dynamic_row.py
    db_models/history.py
    db_models/result.py
    gunicorn_conf.py
    lib/adjusted_date_window.py
    lib/base_currency_provider.py
    lib/constants.py
    lib/currency_provider.py
    lib/date_range_iterator.py
    lib/db/extentions.py
    lib/db/storage.py
    lib/db/timeout_proxy.py
    lib/environment.py
    lib/flag_dependent_settings.py
    lib/flask_logger.py
    lib/history_fetcher.py
    lib/indexer/__init__.py
    lib/indexer/index_builder/__init__.py
    lib/indexer/index_builder/airlines_index_builder.py
    lib/indexer/index_builder/airport_index_builder.py
    lib/indexer/index_builder/time_index_builder.py
    lib/indexer/index_builder/transfer_index_builder.py
    lib/insert_or_nothing_provider.py
    lib/iterrecipes.py
    lib/logging_configurator.py
    lib/national_version_provider.py
    lib/passengers_multiplier.py
    lib/price_converter.py
    lib/price_precision_logger.py
    lib/price_searchers/top_directions_by_date_window_searher.py
    lib/price_searchers/next_days_min_prices_searcher.py
    lib/query_searcher/__init__.py
    lib/query_searcher/fast_min_query_searcher.py
    lib/query_searcher/filter_query_searcher.py
    lib/query_searcher/min_query_searcher.py
    lib/rates_provider.py
    lib/result_builder.py
    lib/result_operation/__init__.py
    lib/result_operation/delete.py
    lib/result_operation/on_conflict.py
    lib/result_operation/update_existing.py
    lib/search_results_queue_consumer/consumer.py
    lib/search_query_finder.py
    lib/settings.py
    lib/tvm.py
    models/batch_prices_form.py
    models/daterange.py
    models/direction_request.py
    models/dump_form.py
    models/filters.py
    models/flight.py
    models/index_data.py
    models/query.py
    models/result.py
    models/search_form.py
    models/top_directions_by_date_window_request.py
    models/next_days_min_prices_request.py
    schemas/batch_min_requests_query.py
    schemas/dump_form.py
    schemas/filters.py
    schemas/query.py
    schemas/range.py
    schemas/search.py
    schemas/top_directions_by_date_window_query.py
    schemas/next_days_min_prices_query.py
    views/dump.py
    views/helpers.py
    views/index_view2.py
    views/min_price_batch_search_view.py
    views/search.py
    views/top_direction_prices_by_date_window_view.py
    views/next_days_min_prices_view.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
