package app

import (
	"a.yandex-team.ru/travel/avia/price_prediction/internal/database"
	"a.yandex-team.ru/travel/avia/price_prediction/internal/dbcache"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
	"time"
)

type TvmConfig struct {
	Enabled       bool          `config:"tvm-enabled"`
	WhiteList     []uint32      `config:"tvm-white-list"`
	CacheTTL      time.Duration `config:"tvm-cache-ttl"`
	CacheMaxItems int           `config:"tvm-cache-max-items"`
}

type Config struct {
	EnvType  string `config:"yandex-environment-type,required" yaml:"yandex_environment_type"`
	HTTP     httpserver.HTTPConfig
	Grpc     grpcserver.GrpcConfig
	Metrics  metricsserver.MetricsConfig
	Logging  logging.Config
	Tvm      TvmConfig
	Database database.Config
	DBCache  dbcache.Config
}

func (c Config) IsDevelopment() bool {
	return c.EnvType == "development"
}

func (c Config) IsTesting() bool {
	return c.EnvType == "testing"
}

var DefaultTvmConfig = TvmConfig{
	Enabled:       false,
	WhiteList:     nil,
	CacheTTL:      3 * time.Minute,
	CacheMaxItems: 128,
}

var Cfg = Config{
	HTTP:     httpserver.DefaultHTTPConfig,
	Grpc:     grpcserver.DefaultGrpcConfig,
	Metrics:  metricsserver.DefaultMetricsConfig,
	Logging:  logging.DefaultConfig,
	Tvm:      DefaultTvmConfig,
	Database: database.DefaultConfig,
	DBCache:  dbcache.DefaultConfig,
}
