package database

import (
	"a.yandex-team.ru/travel/avia/price_prediction/internal/models"
	"a.yandex-team.ru/travel/avia/price_prediction/internal/pgclient"
	"context"
	"golang.yandex/hasql"
	"gorm.io/gorm"
)

type VariantsPriceStatsDBRepository struct {
	pgClient *pgclient.PGClient
	debug    bool
}

func NewVariantsPriceStatsDBRepository(pgClient *pgclient.PGClient, debug bool) *VariantsPriceStatsDBRepository {
	return &VariantsPriceStatsDBRepository{pgClient: pgClient, debug: debug}
}

func (r *VariantsPriceStatsDBRepository) Create(ctx context.Context, stat models.VariantPriceStat) (*models.VariantPriceStat, error) {
	err := r.pgClient.ExecuteInTransaction(
		hasql.Primary,
		func(db *gorm.DB) error {
			db = db.WithContext(ctx)
			return db.Create(&stat).Error
		},
	)
	if err != nil {
		return nil, err
	}
	return &stat, nil
}

func (r *VariantsPriceStatsDBRepository) DeleteAll(ctx context.Context) error {
	err := r.pgClient.ExecuteInTransaction(
		hasql.Primary,
		func(db *gorm.DB) error {
			db = db.WithContext(ctx)
			db = db.Session(&gorm.Session{Context: ctx, AllowGlobalUpdate: true})
			return db.Delete(&models.VariantPriceStat{}).Error
		},
	)
	return err
}
