package dbcache

import (
	"time"
)

type Config struct {
	InitTimeout  time.Duration `config:"DBCACHE_INIT_TIMEOUT" yaml:"init_timeout"`
	UpdateAtHour int           `config:"DBCACHE_UPDATE_AT_HOUR" yaml:"update_at_hour"`
}

var (
	DefaultConfig = Config{
		InitTimeout:  120 * time.Second,
		UpdateAtHour: 10,
	}
)
