package models

type VariantPriceStat struct {
	ID               uint
	PointFromType    string  `gorm:"not null;index:unique_from_to_route_weekday_days,unique"`
	PointFromID      uint    `gorm:"not null;index:unique_from_to_route_weekday_days,unique"`
	PointToType      string  `gorm:"not null;index:unique_from_to_route_weekday_days,unique"`
	PointToID        uint    `gorm:"not null;index:unique_from_to_route_weekday_days,unique"`
	RouteUID         string  `gorm:"not null;index:unique_from_to_route_weekday_days,unique,size:200"`
	DepartureWeekday uint8   `gorm:"not null;index:unique_from_to_route_weekday_days,unique,check:DepartureWeekday < 7"`
	DaysToFlight     uint    `gorm:"not null;index:unique_from_to_route_weekday_days,unique"`
	Q33              float64 `gorm:"type:double precision;not null"`
	Q67              float64 `gorm:"type:double precision;not null"`
}

type PriceStatKey struct {
	PointFromType    string
	PointFromID      uint
	PointToType      string
	PointToID        uint
	RouteUID         string
	DepartureWeekday uint8
	DaysToFlight     uint
}
