package checkprice

import "a.yandex-team.ru/travel/library/go/metrics"

const metricPrefix = "checkprice"

type predictionCategory int

const (
	predictionCategoryUnknown predictionCategory = iota
	predictionCategoryGood
	predictionCategoryBad
	predictionCategoryNotFound // нет данных для прогноза
	predictionCategoryMocked   // данные замоканы для тестинга
)

var metricNames = map[predictionCategory]string{
	predictionCategoryUnknown:  "unknown",
	predictionCategoryGood:     "good",
	predictionCategoryBad:      "bad",
	predictionCategoryNotFound: "not-found",
	predictionCategoryMocked:   "mocked",
}

func writeCheckPriceMetric(category predictionCategory) {
	metrics.GlobalAppMetrics().GetOrCreateCounter(
		metricPrefix,
		nil,
		metricNames[category],
	).Inc()
}
