import os
import logging
import subprocess

import tornado
from tornado.web import Application, RequestHandler

logger = logging.getLogger(__name__)


class PingHandler(RequestHandler):
    def get(self):
        result = subprocess.check_output(['supervisorctl', 'status', 'yandex-revise-celery:*'])

        self.set_header('Content-Type', 'text/plain')
        self.set_status(200 if result.count(b'\n') == result.count(b'RUNNING') else 500)
        self.write(result)


class VersionHandler(RequestHandler):
    def get(self):
        self.set_header('Content-Type', 'text/plain')
        self.write('Tornado version: {}\n'.format(tornado.version))
        self.write('Package tag: {}\n'.format(os.getenv('QLOUD_DOCKER_IMAGE', os.getenv('DEPLOY_DOCKER_IMAGE'))))
        self.write('Package hash: {}\n'.format(os.getenv('QLOUD_DOCKER_HASH', os.getenv('DEPLOY_DOCKER_HASH'))))


def create_application(debug=False):
    return Application(
        [
            (r'/ping', PingHandler),
            (r'/version', VersionHandler),
        ],
        debug=debug,
    )
