from gevent import monkey
monkey.patch_all()

import logging.config

import tornado.process
from tornado.ioloop import IOLoop
from tornado.options import define, options

from travel.avia.revise.utils.logs import sentry_logging
from travel.avia.revise.api import create_application
from travel.avia.revise import settings

logger = logging.getLogger()

define('debug', default=False, help='Debug mode')


def main():
    logging.config.dictConfig(settings.LOGGING)
    sentry_logging(settings.AVIA_SENTRY_DSN)
    application = create_application(debug=options.debug)
    application.listen(settings.API_LISTEN_PORT)
    IOLoop.current().start()


if __name__ == '__main__':
    options.parse_command_line()
    logger.info('Tornado version: {}'.format(tornado.version))
    logger.info('Debug: {}'.format(options.debug))
    main()
