# -*- coding: utf-8 -*-
from gevent import monkey

monkey.patch_all()

import argparse
import base64
import datetime
import logging.config
import os
import json

from travel.avia.revise.utils.logs import sentry_logging
from travel.avia.revise import settings
from travel.avia.revise.revise_task.celery_app import Task, RedirectParams, parse_data

logging.getLogger('travel.avia.revise.extractor.extract').addHandler(logging.StreamHandler())


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('partner', type=str, help='Partner code')
    parser.add_argument('deeplink', type=str, help='Deep link')

    args = parser.parse_args()

    partner_code = args.partner
    url = args.deeplink

    task = Task(
        partner=partner_code,
        redirect_params=RedirectParams(url=url),
        price_value=100,
        shown_price_value=100,
        date_forward=datetime.datetime.now().date()
    )
    report = parse_data(task)
    print('REPORT:')
    print(json.dumps(
        {key: value for key, value in report.items() if key != 'screenshots'},
        indent=4,
    ))

    if 'screenshots' in report:
        print('QUANTITY OF SCREENSHOTS: ', len(report['screenshots']))
        for key, screenshot in enumerate(report['screenshots']):
            ss = base64.b64decode(screenshot)
            image_dir = os.path.join('screenshots')
            if not os.path.exists(image_dir):
                os.makedirs(image_dir)
            image_path = os.path.join(image_dir, str(key) + '.jpg')
            with open(image_path, "wb") as f:
                f.write(ss)
            print('screenshot: {}'.format(image_path))
    else:
        print('NO SCREENSHOTS')


if __name__ == '__main__':
    logging.config.dictConfig(settings.LOGGING)
    sentry_logging(settings.AVIA_SENTRY_DSN)

    main()
