# -*- coding: utf-8 -*-
from contextlib import contextmanager
from typing import Optional
from urllib.error import URLError

from selenium import webdriver
from selenium.common.exceptions import ErrorInResponseException, RemoteDriverServerException, TimeoutException
from selenium.webdriver.common.by import By
from selenium.webdriver.remote.remote_connection import RemoteConnection
from selenium.webdriver.support import expected_conditions
from selenium.webdriver.support.ui import WebDriverWait

from travel.avia.revise import settings


NO_ACCESS_EXCEPTIONS = (
    ErrorInResponseException,
    RemoteDriverServerException,
    TimeoutException,
    URLError,
)


@contextmanager
def get_driver(capabilities=None, partner_code: Optional[str] = None) -> webdriver.Remote:
    capabilities_ = settings.BROWSER_CAPABILITIES_FOR_PARTNER(partner_code=partner_code)

    if capabilities:
        capabilities_.update(capabilities)

    driver = webdriver.Remote(
        command_executor=RemoteConnection(
            settings.SELENIUM_GRID_URL_FOR_PARTNER(partner_code),
            resolve_ip=False,
        ),
        desired_capabilities=capabilities_,
    )

    try:
        driver.maximize_window()
        yield driver
    finally:
        driver.close()


def wait_element_by_css(driver, element_selector, timeout=30):
    WebDriverWait(driver, timeout).until(
        expected_conditions.presence_of_element_located((By.CSS_SELECTOR, element_selector))
    )
