# -*- coding: utf-8 -*-
import time
from selenium.common.exceptions import NoSuchElementException
from selenium.webdriver.common.by import By

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import poll, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 10
    SLEEP_BEFORE_REVIEW = 20

    def __init__(self, driver, variant_params, url, post):
        url_parts = url.split('?', 1)
        url = '{}?_openstat=&{}'.format(url_parts[0], url_parts[1])
        super(Extractor, self).__init__(driver, variant_params, url, post)

    def ticket_changed(self):
        try:
            banner = self.driver.find_element(By.XPATH, (
                '//div[@class="text h-color--white text--paragraph"and '
                '@role="alert" and ./text()="Свободные места с выбранной стоимостью закончились"]'
            ))
            return bool(banner.text)
        except NoSuchElementException:
            return False

    def extract_price(self):
        yield self._screenshot_maker.make(name='first', debug=self.DEBUG)

        price_text = self._find_price_text()
        if not price_text:
            self._click_cart_item()
            time.sleep(5)

        price_text = self._find_price_text()

        yield 'price.text', price_text
        yield self._screenshot_maker.make(name='price parsed')

        if not price_text:
            raise NoSuchElementException('No price on aeroflot page')

        yield {
            'price': parse_price(price_text),
            'currency': None,
        }

    def _find_price_text(self):
        price_element = poll(3, self.driver.find_element_by_css_selector, '.cart__item-price')
        return str(price_element.text)

    def _click_cart_item(self):
        self.driver.find_element_by_css_selector('.cart__item.cart__item--active').click()


extractor = Extractor.entrypoint
