# -*- coding: utf-8 -*-
from selenium.common.exceptions import TimeoutException
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as ec
from selenium.webdriver.support.wait import WebDriverWait

from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import poll_exc

RETRY_COUNT = 3
WEBDRIVER_TIMEOUT = 10
CSS_SELECTOR = '.nemo-checkout-order-details__priceBlock__price'


def extractor(driver, variant_params, url, post):
    yield 'url', url
    driver.get(url)

    wait = WebDriverWait(driver, WEBDRIVER_TIMEOUT)
    yield get_with_screenshot(driver, url)

    price_element = poll_exc(
        RETRY_COUNT,
        TimeoutException,
        wait.until,
        ec.visibility_of_element_located((By.CSS_SELECTOR, CSS_SELECTOR))
    )
    yield 'price', price_element
    yield 'price_text', price_element.text

    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    price = float(price_element.get_attribute('amount'))
    currency = price_element.get_attribute('currency')

    yield {
        'price': price,
        'currency': currency,
    }
