# -*- coding: utf-8 -*-
from selenium.common.exceptions import StaleElementReferenceException

from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(40)
    yield 'url', url
    yield get_with_screenshot(driver, url)

    for i in range(5):
        # агент зачем-то удаляет элементы на странице, а затем снова их создает T_T
        # поэтому пытаемся достать несколько раз
        try:
            price_element = driver.find_element_by_css_selector('[currency-class=new-flights-passInfo__info__price__total__currency]')
            yield 'price_element', price_element

            yield DefaultScreenShotMaker(driver=driver).make('price parsed')

            value = float(price_element.get_attribute('amount'))
            currency = price_element.get_attribute('currency')

            yield 'price', value
            yield 'currency', currency

            yield {
                'price': value,
                'currency': currency,
            }
        except StaleElementReferenceException:
            pass
        else:
            break
