# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(30)
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price = driver.find_element_by_xpath((
        '//div[@id="trip_summary"]'
        '//p[@id="ts_total_sum_block"]'
        '//span[@id="ts_total_sum"]'
    ))
    price_text = str(price.text)
    yield 'price', price
    yield 'price_text', price_text
    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    price_raw, currency = price_text.strip().rsplit(None, 1)

    yield {
        'price': float(''.join(price_raw.split())),
        'currency': currency,
    }
