# -*- coding: utf-8 -*-
from typing import Dict, Iterator

from selenium.webdriver import Remote
from selenium.webdriver.remote.webelement import WebElement

from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import wait_for_element, get_currency, parse_price

_DEBUG = False


def extractor(driver, variant_params, url, post):
    # type: (Remote, Dict, str, Dict) -> Iterator
    yield 'url', url
    yield get_with_screenshot(driver, url, debug=_DEBUG)

    base_css = '#ShortPriceSummary > div.price.miles-discount-final'

    price_css = 'span.bold'

    base_element = wait_for_element(driver, base_css, 40)  # type: WebElement
    yield 'base_element', base_element

    price_element = base_element.find_element_by_css_selector(price_css)  # type: WebElement
    yield 'price_element', price_element

    price_text = price_element.text
    yield 'price_text', price_text

    currency_text = base_element.text
    yield 'currency_text', currency_text

    price = parse_price(price_text)
    yield 'price', price

    currency = get_currency(currency_text)
    yield 'currency', currency

    yield DefaultScreenShotMaker(driver=driver).make('final', debug=_DEBUG)

    yield {
        'price': price,
        'currency': currency,
    }
