# -*- coding: utf-8 -*-
from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.extractor.report import FullPageScreenShotMaker
from travel.avia.revise.utils.helpers import parse_price, get_currency


def extract_price(driver, variant_params, url, post):
    price_element = driver.find_element_by_xpath((
        '//div[@class="page-main"]'
        '//div[@class="processing-checklist_item-total"]'
        '//span[@class="b-price"]'
    ))
    price_text = price_element.text

    yield 'price_text', price_text

    price = parse_price(price_text)
    yield 'price', price
    currency = get_currency(price_text)
    yield 'currency', currency

    screenshot_maker = FullPageScreenShotMaker(driver=driver)
    yield screenshot_maker.make('price parsed')

    yield {
        'price': price,
        'currency': currency,
    }


class Extractor(BasePartnerExtractor):
    SLEEP_BEFORE_REVIEW = 40
    OLD_STYLE_EXTRACTOR = extract_price

    def ticket_changed(self):
        try:
            modal_tooltip_el = self.driver.find_element_by_xpath((
                '//div[@class="ReactModalPortal"]'
                '//div[@class="modal-tooltip-content"]'
            ))
            return 'результат поиска устарел' in modal_tooltip_el.text.lower()
        except NoSuchElementException:
            return False


extractor = Extractor.entrypoint
