# -*- coding: utf-8 -*-
import json

from travel.avia.revise.extractor.report import get_with_screenshot


def extractor(driver, variant_params, url, post):
    """
    Парсилка морды avia.yandex.ru
    Если надо потестировать revise, не делая запросы партнёрам.

    curl -X POST -H "Content-Type: application/json" -d '{
    "partner_code": "avia_yandex",
    "post": null,
    "url": "http://[YOUR_FRONT_HOST]/city/mow/svx/moskva-ekaterinburg?lang=ru",
    "variant_params": {
        "national_version": "ru",
        "passengers": {
            "adults": 1,
            "children": 0,
            "infants": 0
        },
        "point_from": "c213",
        "point_to": "c254"
    }
    }' "http://[YOUR_REVISE_HOST]/robot/extractor/"

    """
    driver.implicitly_wait(40)
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price_element = driver.find_element_by_css_selector('.offer_kb-big .price_kb')
    raw_value = json.loads(price_element.get_attribute('data-options'))

    price = raw_value['options']['price']

    yield {
        'price': price['value'],
        'currency': price['currency'],
    }
