# -*- coding: utf-8 -*-
from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import parse_price, get_currency


class Extractor(BasePartnerExtractor):
    ALWAYS_CHECK_PRICE_CHANGE = True

    def ticket_changed(self):
        try:
            banner = self.driver.find_elements_by_xpath(
                '//*[contains(text(), "К сожалению, авиакомпания не подтвердила наличие мест по выбранному тарифу.'
            )
            return bool(banner)
        except NoSuchElementException:
            return False

    def extract_price(self):
        price_selector = '.AviaBookingOrderSubmit__Price__Value .Price__Value'
        price_element = self.driver.find_element_by_css_selector(price_selector)
        price_text = price_element.text
        yield 'price_text', price_text
        price = parse_price(price_text)
        yield 'price', price

        currency_selector = '.AviaBookingOrderSubmit__Price__Value .Price__Label'
        currency_element = self.driver.find_element_by_css_selector(currency_selector)
        currency_text = currency_element.text
        yield 'currency_text', currency_text
        currency = get_currency(currency_text)
        yield 'currency', currency

        yield self._screenshot_maker.make('price parsed')

        yield {
            'price': price,
            'currency': currency,
        }


extractor = Extractor.entrypoint
