# -*- coding: utf-8 -*-
import re

from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(40)

    yield 'url', url
    yield get_with_screenshot(driver, url)

    price = driver.find_element_by_xpath((
        '//div[@class="paymentForm calc"]'
        '//span[@class="total-amount"]'
        '//span[@class="b-price"]'
    ))

    price_text = str(price.text)
    yield 'price', price
    yield 'price_text', price_text
    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    m = re.search(r'([\d\s]+)(.*)', price_text, re.S | re.U)

    yield 're.match', m

    price_raw, currency = m.groups()

    yield {
        'price': float(''.join(price_raw.split())),
        'currency': ''.join(currency.strip().split()),
    }
