# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 20
    SLEEP_BEFORE_REVIEW = 20

    def extract_price(self):
        price_element = self.driver.find_element_by_css_selector('.ts-flights_order-button .offer__price')
        yield 'price_element', price_element
        yield 'price.text', price_element.text
        try:
            value = parse_price(price_element.text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make('price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(price_element.text)
        yield self._screenshot_maker.make('parsing_complete', debug=self.DEBUG)
        yield {
            'price': value,
            'currency': currency,
        }

extractor = Extractor.entrypoint
