# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import wait_for_element, parse_price, get_currency


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    try:
        price_element = wait_for_element(driver, '.offer-btn.big-btn', 40)
    except Exception as e:
        raise Exception(e)

    yield 'price', price_element
    yield 'price_text', price_element.text

    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    price_text = price_element.text
    price = parse_price(price_text)
    currency = get_currency(price_text)

    yield {
        'price': price,
        'currency': currency,
    }
