# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import poll


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(10)
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price_element = poll(8, driver.find_element_by_css_selector, 'input.total_price')
    price_element_value = price_element.get_attribute('value')
    price_text = str(price_element_value)

    yield 'price', price_element
    yield 'price_text', price_text

    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    price = float(''.join(price_element.get_attribute('value').strip().split()))
    yield {
        'price': price,
        'currency': 'RUB'
    }
