# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import wait_for_element


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(40)
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price_element_selector = '.nemo-checkout-order-details__priceBlock__price'

    wait_for_element(driver, price_element_selector, 40)
    price_element = driver.find_element_by_css_selector(price_element_selector)

    yield DefaultScreenShotMaker(driver=driver).make('price parsed')
    yield price_element

    price = float(price_element.get_attribute('amount'))
    currency = price_element.get_attribute('currency')

    yield {
        'price': price,
        'currency': currency
    }
