# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 40
    SLEEP_BEFORE_REVIEW = 20

    def ticket_changed(self):
        banner_css = '.empty-block > h3'
        banner = self.driver.find_element_by_css_selector(banner_css)
        return bool(banner)

    def extract_price(self):
        yield self._screenshot_maker.make('first', debug=self.DEBUG)
        price_element = self.driver.find_element_by_css_selector('.price-flex > .price')
        yield 'price_text', price_element.text

        price = parse_price(price_element.text)
        yield 'price', price
        currency = get_currency(price_element.text)
        yield 'currency', currency

        yield self._screenshot_maker.make('price parsed')

        yield {
            'price': price,
            'currency': currency,
        }


extractor = Extractor.entrypoint
