# -*- coding: utf-8 -*-
from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 40
    SLEEP_BEFORE_REVIEW = 20

    def ticket_changed(self):
        try:
            banner = self.driver.find_elements_by_xpath('//div[contains(text(),"Этот билет уже продан")]')
            return bool(banner)
        except NoSuchElementException:
            return False

    def extract_price(self):
        yield self._screenshot_maker.make('first', debug=self.DEBUG)
        selector = 'div[style = "border-radius: 4px;"] > div > div > div[style] > div > span'
        price_element = self.driver.find_element_by_css_selector(selector)
        yield 'price_text', price_element.text

        price = parse_price(price_element.text)
        yield 'price', price
        currency = get_currency(price_element.text)
        yield 'currency', currency

        yield self._screenshot_maker.make('price parsed')

        yield {
            'price': price,
            'currency': currency,
        }


extractor = Extractor.entrypoint
