# -*- coding: utf-8 -*-
from selenium.common.exceptions import TimeoutException
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as ec
from selenium.webdriver.support.wait import WebDriverWait

from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import poll_exc


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    wait = WebDriverWait(driver, 30)
    price_selector = '.nemo-checkout-order-details__priceBlock__price'

    poll_exc(
        12, TimeoutException,
        wait.until,
        ec.invisibility_of_element_located(
            (By.CSS_SELECTOR, '#loader')
        ),
    )
    price_element = poll_exc(
        4, TimeoutException,
        wait.until,
        ec.visibility_of_element_located(
            (By.CSS_SELECTOR, price_selector)
        ),
    )

    yield DefaultScreenShotMaker(driver=driver).make('price parsed')
    yield price_element

    value = float(price_element.get_attribute('amount'))
    currency = price_element.get_attribute('currency')

    yield {
        'price': value,
        'currency': currency
    }
