# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import parse_price, get_currency, wait_for_element_xpath


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    prices_xpath = (
        '//div[@class="ReservationBill-item-priceWrapper"]'
        '//div[@class="ReservationBill-item-price"]'
    )
    price = wait_for_element_xpath(driver, prices_xpath, 30)

    price_text = str(price.text)
    yield 'price', price
    yield 'price_text', price_text
    yield DefaultScreenShotMaker(driver=driver).make('second')

    assert price.is_displayed()

    yield {
        'price': parse_price(price_text),
        'currency': get_currency(price_text)
    }
