# -*- coding: utf-8 -*-

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    SLEEP_BEFORE_REVIEW = 20

    def ticket_changed(self):
        banner_css = 'img[src="//www.kupibilet.ru/cdn/statics/media/confusion.7ae5e5.svg"]'
        banner = self.driver.find_element_by_css_selector(banner_css)
        return bool(banner)

    def extract_price(self):
        self.driver.set_window_size(1600, 2160)
        yield self._screenshot_maker.make('first', debug=self.DEBUG)
        price_selector = 'div[class^="FluidLayout"] span[class^="styled__Price"] > h3'
        price_element = self.driver.find_element_by_css_selector(price_selector)
        yield 'price_element', price_element
        yield 'price.text', price_element.text

        price_text = str(price_element.text)

        try:
            value = parse_price(price_text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make('price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(price_text)

        yield {
            'price': value,
            'currency': currency,
        }


extractor = Extractor.entrypoint
