# -*- coding: utf-8 -*-
from typing import Iterator, Any

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    def ticket_changed(self):
        unavailability_warning_xpath = '//div[contains(text(),"билеты закончились")]'
        unavailability_warning = self.driver.find_elements_by_xpath(unavailability_warning_xpath)
        return bool(unavailability_warning)

    def extract_price(self) -> Iterator[Any]:
        yield self._screenshot_maker.make(name='first', debug=self.DEBUG)
        price_element = self.driver.find_element_by_css_selector('.booking-actions__price .price')
        yield 'price_element', price_element
        yield 'price.text', price_element.text

        try:
            value = parse_price(price_element.text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make(name='price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(price_element.text)

        yield {
            'price': value,
            'currency': currency,
        }


extractor = Extractor.entrypoint
