# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import parse_price, get_currency, wait_for_element


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    driver.switch_to.frame('myreis_iframe')
    price_element = wait_for_element(driver, '#total_ticket', 60)
    yield 'price_element', price_element

    yield DefaultScreenShotMaker(driver=driver).make('price')

    yield {
        'price': parse_price(price_element.text),
        'currency': get_currency(price_element.text),
    }
