# -*- coding: utf-8 -*-
from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 40
    SLEEP_BEFORE_REVIEW = 20

    def ticket_changed(self):
        try:
            banner = self.driver.find_element_by_css_selector('.no-tickets')
            return bool(banner.text)
        except NoSuchElementException:
            return False

    def extract_price(self):
        yield self._screenshot_maker.make('first', debug=self.DEBUG)
        price_selector = '.text-3xl'
        price_element = self.driver.find_element_by_css_selector(price_selector)
        yield 'price_text', price_element.text

        numeric_price = parse_price(price_element.text)
        price = float(numeric_price)
        yield 'price', price

        currency = get_currency(price_element.text.lower())
        yield 'currency', currency

        yield self._screenshot_maker.make('price parsed')
        yield {
            'price': price,
            'currency': currency,
        }


extractor = Extractor.entrypoint
