# -*- coding: utf-8 -*-
from selenium.webdriver import ActionChains

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    ALWAYS_CHECK_PRICE_CHANGE = True
    SLEEP_BEFORE_REVIEW = 10

    def ticket_changed(self):
        unavailability_warning_xpath = '//span[@data-locator="new-price-money"]'
        unavailability_warning = self.driver.find_elements_by_xpath(unavailability_warning_xpath)
        return bool(unavailability_warning)

    def extract_price(self):
        yield self._screenshot_maker.make('before parsing price', debug=self.DEBUG)
        price_element = self.driver.find_element_by_xpath('//div[@data-locator="total-sum"]/span/span[1]')
        currency_element = self.driver.find_element_by_xpath('//div[@data-locator="total-sum"]/span/span[2]')

        ActionChains(self.driver).move_to_element(price_element).perform()

        yield 'price_element', price_element
        yield 'price.text', price_element.text
        try:
            value = parse_price(price_element.text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make('price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(currency_element.text)
        yield self._screenshot_maker.make('after parsing', debug=self.DEBUG)
        yield {
            'price': value,
            'currency': currency,
        }


extractor = Extractor.entrypoint
