# -*- coding: utf-8 -*-
from typing import Iterator, Any

from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.extractor.report import DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import poll, get_currency, parse_price


def extract_price(driver, variant_params, url, post) -> Iterator[Any]:
    price = poll(10, driver.find_element_by_css_selector, 'div[class^=OrderPrices_totalValue]')
    currency = get_currency(price.text)
    price_value = parse_price(price.text)

    yield 'price', price
    yield 'price_text', price.text
    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    assert price.is_displayed()

    yield {
        'price': price_value,
        'currency': currency,
    }


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 10
    OLD_STYLE_EXTRACTOR = extract_price

    def ticket_changed(self):
        try:
            banner = self.driver.find_element_by_css_selector('div[class^=PageError_wrapper]')
            return 'билеты по такой цене закончились' in banner.text.lower()
        except NoSuchElementException:
            return False


extractor = Extractor.entrypoint
