# -*- coding: utf-8 -*-
import re

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import poll, get_currency


class Extractor(BasePartnerExtractor):
    ALWAYS_CHECK_PRICE_CHANGE = True
    SLEEP_BEFORE_REVIEW = 10

    def ticket_changed(self):
        unavailability_warning_xpath = './/div[@id="warning"]/div/div[@id="no_results"]'
        unavailability_warning = self.driver.find_elements_by_xpath(unavailability_warning_xpath)
        return bool(unavailability_warning)

    def extract_price(self):
        yield self._screenshot_maker.make('before parsing price', debug=self.DEBUG)

        price_element = poll(
            3, self.driver.find_element_by_xpath, './/div[@data-qa="amount_shopCart" and @class="price-i"]'
        )
        currency_element = self.driver.find_element_by_xpath(
            './/div[@data-qa="amount_shopCart" and @class="price-i"]/small[@data-qa="currency_shopCart"]'
        )

        yield 'price_element', price_element
        yield 'currency_element', currency_element

        price = self.parse_price(price_element.text)
        currency = get_currency(currency_element.text.lower())

        yield self._screenshot_maker.make('price parsed')

        yield {
            'price': price,
            'currency': currency,
        }

    @staticmethod
    def parse_price(price):
        """Remove all characters unless digit for s7"""
        return float(re.sub(r'[^\d]', '', price))


extractor = Extractor.entrypoint
