# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(40)

    yield 'url', url
    yield get_with_screenshot(driver, url)

    price = driver.find_element_by_xpath((
        '//div[@class="aside"]'
        '//div[@class="travel-cost__total"]'
    ))
    yield 'price', price
    yield 'price.text', price.text
    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    price_el, currency_el = price.find_elements_by_xpath('span')

    yield {
        'price': float(''.join(price_el.text.strip().split())),
        'currency': currency_el.get_attribute('class'),
    }
