# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    SLEEP_BEFORE_REVIEW = 20

    def ticket_changed(self):
        unavailability_warning_xpath = \
            '//span[contains(text(),"Fare is no longer available.") or contains(text(),"Тариф уже недоступен.")]'
        unavailability_warning = self.driver.find_elements_by_xpath(unavailability_warning_xpath)
        return bool(unavailability_warning)

    def extract_price(self):
        price_element = self.driver.find_element_by_css_selector('#price-block')
        yield 'price_element', price_element
        yield 'price.text', price_element.text

        try:
            value = parse_price(price_element.text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make('price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(price_element.text)

        yield self._screenshot_maker.make('parsing_complete', debug=self.DEBUG)

        yield {
            'price': value,
            'currency': currency,
        }


extractor = Extractor.entrypoint
