# -*- coding: utf-8 -*-
from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 40
    SLEEP_BEFORE_REVIEW = 30
    ALWAYS_CHECK_PRICE_CHANGE = True

    def ticket_changed(self):
        try:
            banner = self.driver.find_element_by_css_selector('.lk-form__block')
            return bool(banner.text)
        except NoSuchElementException:
            return False

    def modify_url(self, url):
        return '{}{}'.format(url, '&marker=revise')

    def extract_price(self):
        self.driver.execute_script("document.body.style.zoom = '60%'")
        price_element = self.driver.find_element_by_css_selector('div[class="amount__val"]')
        yield 'price_element', price_element
        yield 'price.text', price_element.text

        try:
            value = parse_price(price_element.text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make('price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(price_element.text)

        yield self._screenshot_maker.make('parsing_complete', debug=self.DEBUG)

        yield {
            'price': value,
            'currency': currency,
        }


extractor = Extractor.entrypoint
