# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import parse_price, get_currency


def extractor(driver, variant_params, url, post):
    driver.implicitly_wait(60)

    yield 'url', url
    yield get_with_screenshot(driver, url)

    price = driver.find_element_by_xpath((
        '//div[contains(@class, "flight-menu_footer")]'
        '//strong[contains(@class, "flight-menu_total-price")]'
    ))
    price_text = str(price.text)

    yield 'price', price
    yield 'price_text', price_text
    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    yield {
        'price': parse_price(price_text),
        'currency': get_currency(price_text),
    }
