# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker

from travel.avia.revise.utils.helpers import parse_price, get_currency, wait_for_element_xpath


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price_element_xpath = '//div[@data-qa-file="PriceInfoBlock"]'

    price_element = wait_for_element_xpath(
        driver, price_element_xpath, 40
    )
    yield DefaultScreenShotMaker(driver=driver).make('second')

    yield {
        'price': parse_price(price_element.text),
        'currency': get_currency(price_element.text),
    }
