# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker
from travel.avia.revise.utils.helpers import wait_for_element_xpath, parse_price, get_currency


def get_price(driver):
    def first():
        price_xpath = (
            '//div[@id="preselected_option"]'
            '//div[@id="results_box"]'
            '//div[contains(@class, "result_content")]'
            '//div[contains(@class, "rs_top")]'
            '//strong[@id="price_in_title"]'
        )
        price = wait_for_element_xpath(driver, price_xpath, 30)
        price_text = price.get_attribute("title")
        return price, price_text

    def second():
        price_xpath = (
            '//div[@class="booking-item   booking-item-preselected "]'
            '//a[@class="popup-text blue bolder"]'
        )
        price = wait_for_element_xpath(driver, price_xpath, 30)
        price_text = str(price.text)
        return price, price_text

    tries = [first, second]
    for _try in tries:
        try:
            return _try()
        except Exception:
            pass


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    price, price_text = get_price(driver)
    yield 'price', price
    yield 'price_text', price_text
    parsed_price = parse_price(price_text)
    yield DefaultScreenShotMaker(driver=driver).make('price parsed')

    yield {
        'price': parsed_price,
        'currency': get_currency(price_text)
    }
