# -*- coding: utf-8 -*-

from selenium.common.exceptions import NoSuchElementException

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 40
    SLEEP_BEFORE_REVIEW = 20

    def ticket_changed(self):
        try:
            banner = self.driver.find_element_by_css_selector('div[data-testid="ErrorModal-header"] > div > h3')
            return bool(banner)
        except NoSuchElementException:
            return False

    def extract_price(self):
        yield self._screenshot_maker.make('first', debug=self.DEBUG)

        price_css = 'span[data-testid="travelerDetails-cart-priceSummary-totalPrice"]'
        price_element = self.driver.find_element_by_css_selector(price_css)
        yield 'price_text', price_element.text

        price = parse_price(price_element.text)
        yield 'price', price
        currency = get_currency(price_element.text)
        yield 'currency', currency

        yield self._screenshot_maker.make('price parsed')

        yield {
            'price': price,
            'currency': currency,
        }


extractor = Extractor.entrypoint
