# -*- coding: utf-8 -*-
from travel.avia.revise.extractor.report import get_with_screenshot, DefaultScreenShotMaker

from travel.avia.revise.utils.helpers import parse_price, get_currency, wait_for_element


def extractor(driver, variant_params, url, post):
    yield 'url', url
    yield get_with_screenshot(driver, url)

    css_prefix = '#PricePanel span.o-price-flight'

    price_element_css = '{} em.o-price-flight__num'.format(css_prefix)
    price_element = wait_for_element(
        driver, price_element_css, 40
    )
    yield 'price_element', price_element
    price = parse_price(price_element.text)
    yield 'price', price

    currency_css = '{} span.o-price-flight__currency'.format(css_prefix)
    currency_element = wait_for_element(driver, currency_css, 10)
    yield 'currency_element', currency_element
    currency = get_currency(currency_element.text)
    yield 'currency', currency

    yield DefaultScreenShotMaker(driver=driver).make('second')

    yield {
        'price': price,
        'currency': currency,
    }
