# -*- coding: utf-8 -*-
from selenium.webdriver.common.keys import Keys

from travel.avia.revise.extractor.base_partner_extractor import BasePartnerExtractor
from travel.avia.revise.utils.helpers import get_currency, parse_price


class Extractor(BasePartnerExtractor):
    IMPLICITLY_WAIT_TIME = 40
    SLEEP_BEFORE_REVIEW = 20

    def extract_price(self):
        self.driver.execute_script("document.body.style.zoom = '75%'")
        yield self._screenshot_maker.make('first', debug=self.DEBUG)
        price_element = self.driver.find_element_by_css_selector('.price_xxl')
        yield 'price_element', price_element
        yield 'price.text', price_element.text

        try:
            value = parse_price(price_element.text)
        except (ValueError, TypeError):
            yield self._screenshot_maker.make('price_parsing_error', debug=self.DEBUG)
            value = None
        currency = get_currency(price_element.text)

        self._scroll_to_page_down()
        yield self._screenshot_maker.make('after parsing', debug=self.DEBUG)

        yield {
            'price': value,
            'currency': currency,
        }

    def _scroll_to_page_down(self):
        html = self.driver.find_element_by_tag_name('html')
        html.send_keys(Keys.END)


extractor = Extractor.entrypoint
